import os
import json
from http.server import SimpleHTTPRequestHandler, HTTPServer

VIDEO_DIR = "videos"  # Directory containing your video files

class CustomHandler(SimpleHTTPRequestHandler):
    def do_GET(self):
        if self.path == "/api/videos":  # API endpoint to get the video list
            try:
                video_files = [
                    f for f in os.listdir(VIDEO_DIR)
                    if f.lower().endswith(('.mp4', '.webm', '.ogg'))  # Add other formats as needed
                ]
                response = json.dumps(video_files)
                self.send_response(200)
                self.send_header("Content-Type", "application/json")
                self.end_headers()
                self.wfile.write(response.encode("utf-8"))
            except Exception as e:
                self.send_response(500)
                self.send_header("Content-Type", "application/json")
                self.end_headers()
                error_response = json.dumps({"error": str(e)})
                self.wfile.write(error_response.encode("utf-8"))
        else:
            super().do_GET()  # Serve other files (e.g., HTML, videos)

# Start the HTTP server
def run(server_class=HTTPServer, handler_class=CustomHandler, port=8000):
    server_address = ('0.0.0.0', port)  # Bind to all network interfaces
    httpd = server_class(server_address, handler_class)
    print(f"Serving on http://0.0.0.0:{port}")
    print(f"Serving videos from: {os.path.abspath(VIDEO_DIR)}")
    httpd.serve_forever()

if __name__ == "__main__":
    run()
