from http.server import SimpleHTTPRequestHandler, HTTPServer
import os
import json

class CustomHandler(SimpleHTTPRequestHandler):
    def do_GET(self):
        if self.path == '/list-images':
            # Get all image filenames from the "images/" directory
            images_dir = os.path.join(os.getcwd(), 'images')
            image_files = [f for f in os.listdir(images_dir) if f.lower().endswith(('.png', '.jpg', '.jpeg', '.gif', '.bmp'))]
            # Send JSON response
            self.send_response(200)
            self.send_header('Content-type', 'application/json')
            self.end_headers()
            self.wfile.write(json.dumps(image_files).encode())
        else:
            super().do_GET()

if __name__ == '__main__':
    port = 8000
    host = '0.0.0.0'  # Listen on all interfaces
    server = HTTPServer((host, port), CustomHandler)
    print(f"Server started at http://{host}:{port}")
    server.serve_forever()
